package com.izenpe.zain.cliente.xades;

import org.apache.axis.encoding.Base64;

import com.izenpe.zain.cliente.util.Constantes;
import com.izenpe.zain.cliente.util.Propiedades;
import com.izenpe.zain.cliente.util.ZainUtil;
import com.safelayer.trustedx.client.smartwrapper.Constants;
import com.safelayer.trustedx.client.smartwrapper.SmartVerifyRequest;
import com.safelayer.trustedx.client.smartwrapper.SmartVerifyResponse;

public class VerificacionFirmaXMLDetached {
	//Nombres de los ficheros a utilizar para la Verificacin de la firma XAdES.
	private static final String fileName = "Demo.xml";
	private static final String signName = "DemoSignedDetached.xml";
	
	public static void main(String[] args) {
		try {
			/*
			 * Se crea la peticin a travs de la URL definida en ZAIN_ENDPOINT.
			 */
			SmartVerifyRequest smartVerifyReq = new SmartVerifyRequest(Propiedades.ZAIN_ENDPOINT);
				
			//Se establece el perfil XML (XADES) en la peticin de Verificacin de firma.
			smartVerifyReq.setProfile(Constants.Profile.XADES);
			
			/*
			 * Se establece el idioma de la peticin en espaol. 2 posibilidades:
			 * 	 1. Espaol: 'es'
			 * 	 2. Ingls:  'en'
			 */
			smartVerifyReq.setLanguage("es");
			
			//Datos a verificar.
			smartVerifyReq.setInputXmlBase64(Base64.encode(ZainUtil.readBinaryFile("data/input/" + fileName)));
			
//			Firma a verificar.
			smartVerifyReq.setSignatureXmlBase64(Base64.encode(ZainUtil.readBinaryFile("data/output/" + signName)));
			
			//Envo de la peticin.
			SmartVerifyResponse smartVerifyResp = smartVerifyReq.send();
			
			//Se comprueba la validez de la respuesta de Verificacin de firma XMLDSig.
			if (Constantes.RMAJOR_SUCCESS.equals((smartVerifyResp.getResultMajor())) && Constantes.RMINOR_SUCCESS.equals(smartVerifyResp.getResultMinor())) {
				System.out.println("La firma ha sido verificada con xito.");
			} else {
				System.out.println("La firma tiene errores: " + smartVerifyResp.getResultMessage());
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}